<?php
/**
* Template Name: Home
*/

get_header();

$vaPage_className = "va-page-home";

$vaPageTitle = "";
$vaPageContent = "";
$vaPageImage = "";

if(have_posts()):
    while(have_posts()): the_post();
        $vaPageTitle = apply_filters("the_title", $post->post_title);
        if(get_post_custom()["pageHeaderCustomTitle"][0] != ""):
            $vaPageTitle = get_post_custom()["pageHeaderCustomTitle"][0];
        endif;
        $vaPageImage = get_post_custom()["pageHeaderImage"][0];
        $vaPageContent = strip_tags(apply_filters("the_content", $post->post_content), "<h1><h2><h3><strong><em><a><p><br><ul><ol><li><div><img><svg><path>");
    endwhile;
endif;
?>
<article class="<?php echo $vaPage_className; ?>">
    <section class="va-page-content">
        <nav class="va-nav-realisation-wrapper">
            <ul class="va-nav-realisation">
                <li class="va-nav-realisation"><a href="#folder-design"><strong>folder</strong><span>design</span></a></li>
                <li class="va-nav-realisation"><a href="#advertentie-design"><strong>advertentie</strong><span>design</span></a></li>
                <li class="va-nav-realisation"><a href="#logo-huisstijl-design"><strong>logo-huisstijl</strong><span>design</span></a></li>
                <li class="va-nav-realisation"><a href="#mailing-design"><strong>mailing</strong><span>design</span></a></li>
                <li class="va-nav-realisation"><a href="#interior-design"><strong>interior</strong><span>design</span></a></li>
            </ul>
            <div class="va-logo">
                <?php get_template_part("templates/branding/logo"); ?>
            </div>
        </nav>
        <div class="va-p-intro" id="welcome">
            <div class="va-slogan">
                <span><strong>THINKS</strong> OUTSIDE THE BOX</span>
                <span><strong>CREATE</strong>S MANY IDEAS</span>
                <span><strong>MAKE</strong>S YOUR … STRONGER</span>
            </div>
            <div class="va-content">
                <div class="va-text-item">
                    <p>WIE ZIJN WIJ?</p>
                    <p>Grafisch bureau qua3art onder leiding van Nancy De Witte met meer dan 25 jaar evaring in de reclamebranche.</p>
                    <p>&nbsp;</p>
                    <p>WAT DOEN WE?</p>
                    <p>Alle projecten en campagnes, van het kleinste tot het grootste. Van het ontwerp van een logo tot een volledige huisstijl, design van mailings, bedrijfs- en productbrochures, advertenties, belettering en verpakkingen. Ook voor freelance-opdrachten kan u bij ons terecht.</p>
                    <p>Sinds 2020 geven we je ook graag ideeën bij de inrichting van jouw interieur.<br/>Eigen kunst behoort tot de mogelijkheden.</p>
                    <p>&nbsp;</p>
                    <p>WAT BIEDEN WE?</p>
                    <p><strong>Lots of creativity!<br/>Ons motto is flexibiliteit gebaseerd op vertrouwen.</strong></p>
                </div>
            </div>
        </div>
        <?php
            $slider_type = "folder";
            $vaReferenceListArg = array(
                "post_type" => "reference",
                "post_status" => "publish",
                
                "meta_query" => array(
                    array(
                        "key" => "referenceCategory",
                        "value" => $slider_type,
                        "compare" => "=",
                    ),
                ),

                "meta_key" => "postVolgorde",
                "meta_type" => "meta_value_num",
                "orderby" => array(
                    "meta_value" => "DESC",
                    "title" => "ASC",
                ),

                "no_found_rows" => true,
                "posts_per_page" => -1,
            );

            $vaReferenceListQuery = new WP_Query($vaReferenceListArg);
        ?>
        <div class="va-p-slider" id="folder-design">
            <div class="va-p-slider-label"><span><strong>folder</strong><br/>design</span></div>
            <div class="va-p-slider-inner">
                <?php
                    if($vaReferenceListQuery -> have_posts()):
                        while($vaReferenceListQuery -> have_posts()):
                            $vaReferenceListQuery -> the_post();

                            $vaReferenceTitle = get_the_title();
                            $vaReferenceTeaser_medium = va_media_url(get_post_custom()["referenceTeaser"][0], "medium");
                            $vaReferenceTeaser_large = va_media_url(get_post_custom()["referenceTeaser"][0], "large");
                            $vaReferenceImageList = get_post_custom()["referenceImageList"][0];
                            
                            if($vaReferenceTeaser_medium && $vaReferenceTeaser_large):
                                ?>
                                <div class="va-p-slide">
                                    <a href="<?php echo $vaReferenceTeaser_large; ?>" data-lightbox="<?php echo $slider_type; ?>"><img src="<?php echo $vaReferenceTeaser_medium; ?>" alt="<?php echo $vaReferenceTitle; ?>"></a>

                                    <?php
                                        if($vaReferenceImageList):
                                            $vaReferenceImageList = json_decode($vaReferenceImageList, true);
                                            foreach($vaReferenceImageList as $value):
                                                $vaReferenceImageList_item = va_media_url($value, "large");
                                    ?>
                                    <a class="va-hidden" href="<?php echo $vaReferenceImageList_item; ?>" data-lightbox="<?php echo $slider_type; ?>"></a>
                                    <?php
                                            endforeach;
                                        endif;
                                    ?>
                                </div>
                                <?php
                            endif;
                        endwhile;
                    endif;
                ?>
            </div>
            <p class="va-p-slider-description">Klik op het project voor meer info</p>
        </div>
        <?php
            $slider_type = "advertentie";
            $vaReferenceListArg = array(
                "post_type" => "reference",
                "post_status" => "publish",
                
                "meta_query" => array(
                    array(
                        "key" => "referenceCategory",
                        "value" => $slider_type,
                        "compare" => "=",
                    ),
                ),

                "meta_key" => "postVolgorde",
                "meta_type" => "meta_value_num",
                "orderby" => array(
                    "meta_value" => "DESC",
                    "title" => "ASC",
                ),

                "no_found_rows" => true,
                "posts_per_page" => -1,
            );

            $vaReferenceListQuery = new WP_Query($vaReferenceListArg);
        ?>
        <div class="va-p-slider" id="advertentie-design">
            <div class="va-p-slider-label"><span><strong>advertentie</strong><br/>design</span></div>
            <div class="va-p-slider-inner">
                <?php
                    if($vaReferenceListQuery -> have_posts()):
                        while($vaReferenceListQuery -> have_posts()):
                            $vaReferenceListQuery -> the_post();

                            $vaReferenceTitle = get_the_title();
                            $vaReferenceTeaser_medium = va_media_url(get_post_custom()["referenceTeaser"][0], "medium");
                            $vaReferenceTeaser_large = va_media_url(get_post_custom()["referenceTeaser"][0], "large");
                            $vaReferenceImageList = get_post_custom()["referenceImageList"][0];
                            
                            if($vaReferenceTeaser_medium && $vaReferenceTeaser_large):
                                ?>
                                <div class="va-p-slide">
                                    <a href="<?php echo $vaReferenceTeaser_large; ?>" data-lightbox="<?php echo $slider_type; ?>"><img src="<?php echo $vaReferenceTeaser_medium; ?>" alt="<?php echo $vaReferenceTitle; ?>"></a>

                                    <?php
                                        if($vaReferenceImageList):
                                            $vaReferenceImageList = json_decode($vaReferenceImageList, true);
                                            foreach($vaReferenceImageList as $value):
                                                $vaReferenceImageList_item = va_media_url($value, "large");
                                    ?>
                                    <a class="va-hidden" href="<?php echo $vaReferenceImageList_item; ?>" data-lightbox="<?php echo $slider_type; ?>"></a>
                                    <?php
                                            endforeach;
                                        endif;
                                    ?>
                                </div>
                                <?php
                            endif;
                        endwhile;
                    endif;
                ?>
            </div>
            <p class="va-p-slider-description">Klik op het project voor meer info</p>
        </div>
        <?php
            $slider_type = "logo";
            $vaReferenceListArg = array(
                "post_type" => "reference",
                "post_status" => "publish",
                
                "meta_query" => array(
                    array(
                        "key" => "referenceCategory",
                        "value" => $slider_type,
                        "compare" => "=",
                    ),
                ),

                "meta_key" => "postVolgorde",
                "meta_type" => "meta_value_num",
                "orderby" => array(
                    "meta_value" => "DESC",
                    "title" => "ASC",
                ),

                "no_found_rows" => true,
                "posts_per_page" => 50,
            );

            $vaReferenceListQuery = new WP_Query($vaReferenceListArg);
        ?>
        <div class="va-p-slider" id="logo-huisstijl-design">
            <div class="va-p-slider-label"><span><strong>logo-huisstijl</strong><br/>design</span></div>
            <div class="va-p-slider-inner">
                <?php
                    if($vaReferenceListQuery -> have_posts()):
                        while($vaReferenceListQuery -> have_posts()):
                            $vaReferenceListQuery -> the_post();
                            $vaReferenceTitle = get_the_title();
                            $vaReferenceTeaser_medium = va_media_url(get_post_custom()["referenceTeaser"][0], "medium");
                            $vaReferenceTeaser_large = va_media_url(get_post_custom()["referenceTeaser"][0], "large");
                            $vaReferenceImageList = get_post_custom()["referenceImageList"][0];
                            
                            if($vaReferenceTeaser_medium && $vaReferenceTeaser_large):
                                ?>
                                <div class="va-p-slide">
                                    <a href="<?php echo $vaReferenceTeaser_large; ?>" data-lightbox="<?php echo $slider_type; ?>"><img src="<?php echo $vaReferenceTeaser_medium; ?>" alt="<?php echo $vaReferenceTitle; ?>"></a>

                                    <?php
                                        if($vaReferenceImageList):
                                            $vaReferenceImageList = json_decode($vaReferenceImageList, true);
                                            foreach($vaReferenceImageList as $value):
                                                $vaReferenceImageList_item = va_media_url($value, "large");
                                    ?>
                                    <a class="va-hidden" href="<?php echo $vaReferenceImageList_item; ?>" data-lightbox="<?php echo $slider_type; ?>"></a>
                                    <?php
                                            endforeach;
                                        endif;
                                    ?>
                                </div>
                                <?php
                            endif;
                        endwhile;
                    endif;
                ?>
            </div>
            <p class="va-p-slider-description">Klik op het project voor meer info</p>
        </div>
        <?php
            $slider_type = "mailing";
            $vaReferenceListArg = array(
                "post_type" => "reference",
                "post_status" => "publish",
                
                "meta_query" => array(
                    array(
                        "key" => "referenceCategory",
                        "value" => $slider_type,
                        "compare" => "=",
                    ),
                ),

                "meta_key" => "postVolgorde",
                "meta_type" => "meta_value_num",
                "orderby" => array(
                    "meta_value" => "DESC",
                    "title" => "ASC",
                ),

                "no_found_rows" => true,
                "posts_per_page" => -1,
            );

            $vaReferenceListQuery = new WP_Query($vaReferenceListArg);
        ?>
        <div class="va-p-slider" id="mailing-design">
            <div class="va-p-slider-label"><span><strong>mailing</strong><br/>design</span></div>
            <div class="va-p-slider-inner">
                <?php
                    if($vaReferenceListQuery -> have_posts()):
                        while($vaReferenceListQuery -> have_posts()):
                            $vaReferenceListQuery -> the_post();

                            $vaReferenceTitle = get_the_title();
                            $vaReferenceTeaser_medium = va_media_url(get_post_custom()["referenceTeaser"][0], "medium");
                            $vaReferenceTeaser_large = va_media_url(get_post_custom()["referenceTeaser"][0], "large");
                            $vaReferenceImageList = get_post_custom()["referenceImageList"][0];
                            
                            if($vaReferenceTeaser_medium && $vaReferenceTeaser_large):
                                ?>
                                <div class="va-p-slide">
                                    <a href="<?php echo $vaReferenceTeaser_large; ?>" data-lightbox="<?php echo $slider_type; ?>"><img src="<?php echo $vaReferenceTeaser_medium; ?>" alt="<?php echo $vaReferenceTitle; ?>"></a>

                                    <?php
                                        if($vaReferenceImageList):
                                            $vaReferenceImageList = json_decode($vaReferenceImageList, true);
                                            foreach($vaReferenceImageList as $value):
                                                $vaReferenceImageList_item = va_media_url($value, "large");
                                    ?>
                                    <a class="va-hidden" href="<?php echo $vaReferenceImageList_item; ?>" data-lightbox="<?php echo $slider_type; ?>"></a>
                                    <?php
                                            endforeach;
                                        endif;
                                    ?>
                                </div>
                                <?php
                            endif;
                        endwhile;
                    endif;
                ?>
            </div>
            <p class="va-p-slider-description">Klik op het project voor meer info</p>
        </div>
        <?php
            $slider_type = "interior";
            $vaReferenceListArg = array(
                "post_type" => "reference",
                "post_status" => "publish",
                
                "meta_query" => array(
                    array(
                        "key" => "referenceCategory",
                        "value" => $slider_type,
                        "compare" => "=",
                    ),
                ),

                "meta_key" => "postVolgorde",
                "meta_type" => "meta_value_num",
                "orderby" => array(
                    "meta_value" => "DESC",
                    "title" => "ASC",
                ),

                "no_found_rows" => true,
                "posts_per_page" => -1,
            );

            $vaReferenceListQuery = new WP_Query($vaReferenceListArg);
        ?>
        <div class="va-p-slider" id="interior-design">
            <div class="va-p-slider-label"><span><strong>interior</strong><br/>design</span></div>
            <div class="va-p-slider-inner">
                <?php
                    if($vaReferenceListQuery -> have_posts()):
                        while($vaReferenceListQuery -> have_posts()):
                            $vaReferenceListQuery -> the_post();

                            $vaReferenceTitle = get_the_title();
                            $vaReferenceTeaser_medium = va_media_url(get_post_custom()["referenceTeaser"][0], "medium");
                            $vaReferenceTeaser_large = va_media_url(get_post_custom()["referenceTeaser"][0], "large");
                            $vaReferenceImageList = get_post_custom()["referenceImageList"][0];
                            
                            if($vaReferenceTeaser_medium && $vaReferenceTeaser_large):
                                ?>
                                <div class="va-p-slide">
                                    <a href="<?php echo $vaReferenceTeaser_large; ?>" data-lightbox="<?php echo $slider_type; ?>"><img src="<?php echo $vaReferenceTeaser_medium; ?>" alt="<?php echo $vaReferenceTitle; ?>"></a>

                                    <?php
                                        if($vaReferenceImageList):
                                            $vaReferenceImageList = json_decode($vaReferenceImageList, true);
                                            foreach($vaReferenceImageList as $value):
                                                $vaReferenceImageList_item = va_media_url($value, "large");
                                    ?>
                                    <a class="va-hidden" href="<?php echo $vaReferenceImageList_item; ?>" data-lightbox="<?php echo $slider_type; ?>"></a>
                                    <?php
                                            endforeach;
                                        endif;
                                    ?>
                                </div>
                                <?php
                            endif;
                        endwhile;
                    endif;
                ?>
            </div>
            <p class="va-p-slider-description">Klik op het project voor meer info</p>
        </div>
        <div class="va-p-footer" id="contact">
            <div class="va-slogan">
                <span><strong>THINKS</strong> OUTSIDE THE BOX</span>
                <span><strong>CREATE</strong>S MANY IDEAS</span>
                <span><strong>MAKE</strong>S YOUR … STRONGER</span>
            </div>
            <div class="va-content">
                <div class="va-text-item">
                    <p><span class="communication-design">communication design <span></span><span></span><span></span><span></span></span></p>
                    <p>BUSINESS-TO-BUSINESS</p>
                    <p>Wij helpen jouw project of dienst te profileren en verkopen.<br/>De juiste boodschap via het juiste kanaal tot bij de juiste doelgroep.</p>
                    <p>&nbsp;</p>
                    <p><span class="interior-design"><?php get_template_part("templates/branding/logo-icon"); ?>Interior design ideas</span></p>
                    <p>HOME SWEET HOME</p>
                    <p>Wij helpen je bij het vinden van de juiste kleuren en accenten.<br/>Kunst als eyecatcher behoren tot de mogelijkheden.</p>
                    <p>&nbsp;</p>
                    <p class="contact">MORE INFO: <a href="mailto:nancy@qua3art.be" class="email">nancy@qua3art.be</a><br/>
                    <a href="tel:+32475391505" class="phone">+32 (0)475 39 15 05</a></p>
                </div>
            </div>
        </div>
        <?php echo $vaPageContent; ?>
    </section>
</article>
<?php
get_footer();
?>