(function ($){
    var App = (function() {

    function App(){}

    var scrollBarWidth = 0,
        isScrolling = false;

    App.prototype.init = function() {
        scrollBarWidth = getScrollBarWidth();
        
        let hash = checkAnkerInUrl();
        if(hash != false){
            scrollToAnchor(hash);
        }

        loadInBlazy();
        // initHeader();
        // initFieldWrapperFocus();
        // setClickEventCheckbox();
        loadInParagraphSlider();
        
        // setScrollEventHeader();

        $('a[href*="#"]').click(function(event) {
            let target = $(this).attr("href");

            if ($(target).length > 0) {
                event.preventDefault();
                scrollToAnchor(target, this);
            }
        });
    };

    function checkAnkerInUrl() {
    let hash = location.hash;

    // if (hash != "" && hash.charAt(0) == "#" && $(hash).length > 0) {
    if (hash != "" && hash.charAt(0) == "#") {
        return hash;
    } else {
        return false;
    }
}

    function scrollToAnchor(element, trigger) {
    let target = $(element);

    if (target.length > 0) {
        let header = $("#va-header"),
            targetOffsetTop = target.offset().top,
            headerHeight = parseInt(header.outerHeight(), 10) > 0 ? parseInt(header.outerHeight(), 10) : 0,
            headerTop = parseInt(header.css("top"), 10) > 0 ? parseInt(header.css("top"), 10) : 0,
            scrollTopValue = targetOffsetTop - headerHeight - headerTop;

        if (window.innerWidth > 984) {
            if ($(trigger).parent().hasClass("va-nav-realisation")) {
                scrollTopValue = scrollTopValue - parseInt($(".va-nav-realisation-wrapper").outerHeight(), 10);
            } else {
                scrollTopValue = scrollTopValue - parseInt($(".va-nav-realisation-wrapper").outerHeight(), 10) + 90;
            }
        }

        if (scrollTopValue < 0) {
            scrollTopValue = 0;
        }

        if (isScrolling == false) {
            event.preventDefault();
            $("html, body").animate(
                {
                    scrollTop: scrollTopValue,
                },
                {
                    duration: 1000,
                    start: function () {
                        isScrolling = true;
                    },
                    complete: function () {
                        isScrolling = false;
                    },
                }
            );
        }
    }
}

    function loadInBlazy(){
    if (typeof Blazy !== 'undefined') {
        var blazy = new Blazy({
            loadInvisible: true,
            offset: 120
        });

        bLazy_carousel = new Blazy({ 
            container: '.va-blazy-slideshow',
            selector: '.va-blazy-slideshow .b-lazy',
            loadInvisible: true
        });
    }
}
    function getScrollBarWidth(){

    let scrollBarWidth = 0;
    let inner = document.createElement('p');
    inner.style.width = '100%';
    inner.style.height = '200px';

    let outer = document.createElement('div');
    outer.style.position = 'absolute';
    outer.style.top = '0px';
    outer.style.left = '0px';
    outer.style.visibility = 'hidden';
    outer.style.width = '200px';
    outer.style.height = '150px';
    outer.style.overflow = 'hidden';
    outer.appendChild(inner);

    document.body.appendChild(outer);
    let w1 = inner.offsetWidth;
    outer.style.overflow = 'scroll';
    let w2 = inner.offsetWidth;
    if (w1 == w2) w2 = outer.clientWidth;

    document.body.removeChild(outer);

    scrollBarWidth = w1 - w2;
    
    return scrollBarWidth;
}

    // Import components

    // Import elements
    //  "elements/header.js"

    // Import paragraphs
    function loadInParagraphSlider() {
    if (typeof slick !== undefined) {
        if ($(".va-p-slider .va-p-slider-inner").length > 0) {
            let slideshow = $(".va-p-slider .va-p-slider-inner");

            slideshow
                .slick({
                    slide: ".va-p-slide",
                    infinite: false,
                    autoplay: false,
                    speed: 300,
                    pauseOnFocus: false,
                    pauseOnHover: false,
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    dots: false,
                    arrows: true,
                    fade: false,
                    prevArrow:
                        '<div class="va-p-slider-arrow prev"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 205.55 360.63"><path d="M21.71 360.63c-6.35-1.65-12-4.3-16.27-9.63a25.08 25.08 0 0 1-.15-31 56.8 56.8 0 0 1 4.49-4.95q65.73-65.77 131.51-131.5a27.63 27.63 0 0 0 4-4.23c-1.24-.69-2.71-1.14-3.68-2.1Q75.17 110.93 8.81 44.53C1 36.72-2 27.69 1.4 17 6.47 1.09 26.9-5.24 40.1 4.93a43.69 43.69 0 0 1 4.23 3.71q76.23 76.19 152.43 152.42c9.49 9.5 11.44 21.3 5.13 32a36.66 36.66 0 0 1-5.79 7q-74.17 74.26-148.38 148.5c-5.48 5.5-11.13 10.4-19 12Z"/></svg></div>',
                    nextArrow:
                        '<div class="va-p-slider-arrow next"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 205.55 360.63"><path d="M21.71 360.63c-6.35-1.65-12-4.3-16.27-9.63a25.08 25.08 0 0 1-.15-31 56.8 56.8 0 0 1 4.49-4.95q65.73-65.77 131.51-131.5a27.63 27.63 0 0 0 4-4.23c-1.24-.69-2.71-1.14-3.68-2.1Q75.17 110.93 8.81 44.53C1 36.72-2 27.69 1.4 17 6.47 1.09 26.9-5.24 40.1 4.93a43.69 43.69 0 0 1 4.23 3.71q76.23 76.19 152.43 152.42c9.49 9.5 11.44 21.3 5.13 32a36.66 36.66 0 0 1-5.79 7q-74.17 74.26-148.38 148.5c-5.48 5.5-11.13 10.4-19 12Z"/></svg></div>',
                    responsive: [
                        {
                            breakpoint: 1440,
                            settings: {
                                slidesToShow: 3,
                            },
                        },
                        {
                            breakpoint: 984,
                            settings: {
                                slidesToShow: 2,
                            },
                        },
                        {
                            breakpoint: 480,
                            settings: {
                                slidesToShow: 1,
                            },
                        },
                    ],
                })
                .on("afterChange", function (event, slick, currentSlide) {
                    if (bLazy_carousel != null || bLazy_carousel != undefined || bLazy_carousel != "") {
                        bLazy_carousel.revalidate();
                    }
                });

            lightbox.option({
                resizeDuration: 200,
                wrapAround: true,
            });
        }
    }
}


    // Import page-specific js

    return App;
})();


    document.addEventListener("DOMContentLoaded", function(){
        var app = new App();
        app.init();
    });

    window.onpageshow = function(event) {
    if (event.persisted) {
        if($('#va-header').hasClass('open')){
            $('#va-header').removeClass('open');
        }

        if($('.va-hamburger-container').hasClass('open')){
            $('.va-hamburger-container').removeClass('open');
        }
    }
}
    if(!document.body.classList.contains('js-loaded')){
    document.body.classList.add('js-loading');

    window.addEventListener("load", pageLoaded);

    function pageLoaded() {
        document.body.classList.remove('js-loading');
        document.body.classList.add('js-loaded');
    }
}

})(jQuery);