<!DOCTYPE html>
<?php
$vaOGImage = get_template_directory_uri() . "/assets/share.jpg";

if(has_post_thumbnail()):
    $vaOGImage = get_the_post_thumbnail_url($post->ID, "og_image");
    
    if($vaOGImage == ""):
        $vaOGImage = get_template_directory_uri() . "/assets/share.jpg";
    endif;
endif;

if(is_user_logged_in()):
?>
    <html lang="nl" style="margin-top: 0 !important;" class="va-header-admin-bar">
<?php else: ?>
    <html lang="nl">
<?php endif; ?>
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="author" content="VA Webdesign"/>
    <meta name="theme-color" content="#FFFFFF">
    <meta property="og:image" content="<?php echo $vaOGImage; ?>">
    <link rel="apple-touch-icon-precomposed" sizes="57x57" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/apple-touch-icon-57x57.png" />
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/apple-touch-icon-114x114.png" />
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/apple-touch-icon-72x72.png" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/apple-touch-icon-144x144.png" />
    <link rel="apple-touch-icon-precomposed" sizes="60x60" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/apple-touch-icon-60x60.png" />
    <link rel="apple-touch-icon-precomposed" sizes="120x120" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/apple-touch-icon-120x120.png" />
    <link rel="apple-touch-icon-precomposed" sizes="76x76" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/apple-touch-icon-76x76.png" />
    <link rel="apple-touch-icon-precomposed" sizes="152x152" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/apple-touch-icon-152x152.png" />
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/favicon-196x196.png" sizes="196x196" />
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/favicon-96x96.png" sizes="96x96" />
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/favicon-32x32.png" sizes="32x32" />
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/favicon-16x16.png" sizes="16x16" />
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/favicon/favicon-128.png" sizes="128x128" />
    <meta name="application-name" content="<?php echo get_bloginfo("name"); ?>"/>
    <meta name="msapplication-TileColor" content="#FFFFFF" />
    <meta name="msapplication-TileImage" content="<?php echo get_template_directory_uri(); ?>/assets/favicon/mstile-144x144.png" />
    <meta name="msapplication-square70x70logo" content="<?php echo get_template_directory_uri(); ?>/assets/favicon/mstile-70x70.png" />
    <meta name="msapplication-square150x150logo" content="<?php echo get_template_directory_uri(); ?>/assets/favicon/mstile-150x150.png" />
    <meta name="msapplication-wide310x150logo" content="<?php echo get_template_directory_uri(); ?>/assets/favicon/mstile-310x150.png" />
    <meta name="msapplication-square310x310logo" content="<?php echo get_template_directory_uri(); ?>/assets/favicon/mstile-310x310.png" />
    
    <?php wp_head();?>
</head>
<body>
<header id="va-header">
    <div id="va-header-container" class="va-container-large">
        <div id="va-header-grid">
            <div class="va-logo">
                <a href="<?php echo get_site_url(); ?>" title="home" rel="home">
                    <?php get_template_part("templates/branding/logo-small"); ?>
                </a>
            </div>
            <div class="va-nav-grid">
                <div class="va-nav-grid-inner">
                    <div class="va-nav-menu">
                        <nav class="va-navigation">
                            <?php wp_nav_menu(array("theme_location" => "header-primary")); ?>
                            <?php get_template_part("templates/info/social-media"); ?>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<main>