<?php
/*
	==========================================
	 Update client role
	==========================================
*/

function va_add_client_role() {
    if (get_role("client")){
        // Get the client role
        $role = get_role("client");

        // Configure custom post "service" capabilities
        $role->add_cap("read_private_references", true); // allow user to read private service
        $role->add_cap("edit_references", true); // allows editing of the userís own service
        $role->add_cap("edit_others_references", true); // allows the user to edit everyone else's service
        $role->add_cap("edit_published_references", true); // allows the user to edit published service
        $role->add_cap("edit_private_references", true); // allows the user to edit private service
        $role->add_cap("delete_published_references", true); // allows the user to delete published service
        $role->add_cap("delete_private_references", true); // allows the user to edit delete private service
        $role->add_cap("delete_references", true); // allows to delete service written by that user
        $role->add_cap("delete_others_references", true); // allows to delete service written by other users
        $role->add_cap("publish_references", true); // allows the user to publish service, otherwise posts stays in draft mode
    }
    if (!get_role("client")) {
        add_role("client", "client", array(
            "read" => true, // allows this capability, dashboard
            "upload_files" => true, //allows user to upload files
            "edit_files" => true, // allows user to edit files
            "delete_posts" => true, // allow user to delete posts
            "delete_others_posts" => true, // allow user to delete others posts
            "edit_posts" => true, // alow user to edit their own posts
            "edit_pages" => false, // allow user to edit pages
            "edit_others_pages"=>false, // allow user to edit pages
            "edit_published_pages"=>false, // allow user to edit published pages
            "read_private_pages"=>false, // allow user to read private pages
            "edit_private_pages"=>false, // allow user to edit private pages
            "publish_pages" => false, // allow user to publish pages
            "delete_pages" => false, // allow user to delte pages
            "delete_others_pages" => false, // allow user to delte other pages
            "delete_published_pages" => false, // allow user to delte published pages
            "delete_private_pages" => false, // allow user to delte private pages
            "edit_others_posts" => false, // denies user to edit others posts not just their own
            "create_posts" => false, // denies user to create new posts
            "manage_categories" => true, // allow user to manage post categories
            "publish_posts" => false, // denies the user to publish
            "edit_themes" => false, // false denies this capability. User can’t edit your theme
            "install_plugins" => false, // User can't add new plugins
            "update_plugin" => false, // User can’t update any plugins
            "update_core" => false, // user can'tt perform core updates
            "manage_options" => false, // user can't manage options
            "wpseo_manage_options" => false, // denies user to edit wpseo
            "wpseo_edit_advanced_metadata" => false, // denies user to edit wpseo
            "wpseo_bulk_edit" => false, // denies user to edit wpseo
            "wpseo_manage_redirects" => false, // denies user to edit wpseo
        ));
    }    
}

add_action( "admin_init", "va_add_client_role");
?>