<?php
/*
	==========================================
	 Custom Field page header image slideshow
	==========================================
*/

function va_page_header_image_slideshow_meta_box(){
	add_meta_box("page-header-image-slideshow-meta-box", "Pagina afbeelding", "va_page_header_image_slideshow_meta_box_html", "page", "normal", "low");
}

function va_page_header_image_slideshow_meta_box_html(){
    global $post;
	// ophalen data
	if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) return $post_id;
    
    $customValue = get_post_custom($post->ID);

    $vaPageHeaderImage = $customValue["pageHeaderImage"][0];
    $vaPageHeaderCustomTitle = $customValue["pageHeaderCustomTitle"][0];
    $vaPageHeaderContent = $customValue["pageHeaderContent"][0];
    $vaPageHeaderCTAText = $customValue["pageHeaderCTAText"][0];
    $vaPageHeaderCTAUrl = $customValue["pageHeaderCTAUrl"][0];
    ?>
    <div class="va-single-galerij-container">
        <div class="va-custom-post-galerij-container">
            <div class="va-custom-post-input">
                <label>De afbeelding voor bovenaan de pagina:</label>
                <div class="va-custom-post-image">
                    <?php
                    if(!empty($vaPageHeaderImage) && $vaPageHeaderImage != ""){
                        $vaPageHeaderImage = json_decode($vaPageHeaderImage, true);
                        foreach ($vaPageHeaderImage as $key => $value) {
                            ?>
                            <div class="va-custom-post-image-row">
                                <div class="va-custom-post-image-row-preview">
                                    <div class="va-custom-post-image-row-preview-inner" style="background-image: url('<?php echo va_media_url($value, 'thumbnail'); ?>');"></div>
                                </div>
                                <label class="va-custom-post-image-row-name"><?php echo va_file_name($value); ?></label>
                                <input name="pageHeaderImage_<?php echo $key; ?>" type="hidden" value="<?php echo $value; ?>">
                                <div class="va-custom-post-image-row-controls">
                                    <div class="va-custom-post-image-row-control-edit" onclick="add_image_galerij_uploader(this)">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path>
                                            <path d="M0 0h24v24H0z" fill="none"></path>
                                        </svg>
                                    </div>
                                    <div class="va-custom-post-image-row-control-delete" onclick="remove_image_galerij_uploader(this)">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
                                            <path d="M0 0h24v24H0z" fill="none"></path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    }else{
                        ?>
                        <div class="va-custom-post-image-row">
                            <div class="va-custom-post-image-row-preview">
                                <div class="va-custom-post-image-row-preview-inner"></div>
                            </div>
                            <label class="va-custom-post-image-row-name">Geen afbeelding gekozen</label>
                            <input name="pageHeaderImage_0" type="hidden" value="">
                            <div class="va-custom-post-image-row-controls">
                                <div class="va-custom-post-image-row-control-edit" onclick="add_image_galerij_uploader(this)">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                        <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path>
                                        <path d="M0 0h24v24H0z" fill="none"></path>
                                    </svg>
                                </div>
                                <div class="va-custom-post-image-row-control-delete" onclick="remove_image_galerij_uploader(this)">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                        <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
                                        <path d="M0 0h24v24H0z" fill="none"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
        <div class="va-custom-post-galerij-controls">
            <div class="va-custom-post-galerij-control-add-image-row" onclick="addImageRowToSingleGallerijblok(this)">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"></path>
                    <path d="M0 0h24v24H0z" fill="none"></path>
                </svg>
            </div>
        </div>
    </div>
	<div class="va-custom-post-input">
		<label>De titel voor bij de pagina afbeelding (indien leeg wordt de titel van de pagina overgenomen):</label>
        <input name="pageHeaderCustomTitle" value="<?php echo $vaPageHeaderCustomTitle; ?>" type="text" autocomplete="off">
    </div>
	<div class="va-custom-post-input">
        <label>De tekst voor bij de pagina afbeelding:</label>
        <textarea name="pageHeaderContent" rows="5"><?php echo $vaPageHeaderContent ?></textarea>
    </div>
    <!-- <div class="va-custom-post-input">
        <label>De tekst voor de knop onder de bovenstaande tekst:</label>
        <input name="pageHeaderCTAText" value="<?php echo $vaPageHeaderCTAText; ?>" type="text" autocomplete="off">
    </div>
    <div class="va-custom-post-input">
        <label>De link voor de knop onder de bovenstaande tekst:</label>
        <input name="pageHeaderCTAUrl" value="<?php echo $vaPageHeaderCTAUrl; ?>" type="text" autocomplete="off">
    </div> -->
    <?php
}

function va_page_header_image_slideshow_save(){
    global $post;
    if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) {
        return $post_id;
    } else {
        $vaPageHeaderImage_array = array();
        $vaPageHeaderImage_json = "";

        foreach($_POST as $key => $value){
            if($value != ""){
                $needle = "pageHeaderImage_";
                if(strpos($key, $needle) !== false){
                    array_push($vaPageHeaderImage_array, $value);
                }
            }
        }
        
        if($vaPageHeaderImage_array){
            $vaPageHeaderImage_json = json_encode($vaPageHeaderImage_array);
        }

        update_post_meta($post->ID, "pageHeaderImage", $_POST["pageHeaderImage"]);
        update_post_meta($post->ID, "pageHeaderCustomTitle", $_POST["pageHeaderCustomTitle"]);
        update_post_meta($post->ID, "pageHeaderContent", $_POST["pageHeaderContent"]);
        update_post_meta($post->ID, "pageHeaderCTAText", $_POST["pageHeaderCTAText"]);
        update_post_meta($post->ID, "pageHeaderCTAUrl", $_POST["pageHeaderCTAUrl"]);
    }
}
?>