<?php
/*
	==========================================
	 Custom Field page header image
	==========================================
*/

function va_page_header_image_meta_box(){
	add_meta_box("page-header-image-meta-box", "Pagina afbeelding", "va_page_header_image_meta_box_html", "page", "normal", "low");
	add_meta_box("page-header-image-meta-box", "Pagina afbeelding", "va_page_header_image_meta_box_html", "service", "normal", "low");
}

function va_page_header_image_meta_box_html(){
    global $post;
	// ophalen data
	if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) return $post_id;
    
    $customValue = get_post_custom($post->ID);

    $vaPageHeaderImage = $customValue["pageHeaderImage"][0];
    $vaPageHeaderCustomTitle = $customValue["pageHeaderCustomTitle"][0];
    $vaPageHeaderContent = $customValue["pageHeaderContent"][0];
    $vaPageHeaderCTAText = $customValue["pageHeaderCTAText"][0];
    $vaPageHeaderCTAUrl = $customValue["pageHeaderCTAUrl"][0];
    $vaPopupTitle = $customValue["popupTitle"][0];
    $vaPopupContent = $customValue["popupContent"][0];
    $vaPopupCTAText = $customValue["popupCTAText"][0];
    $vaPopupCTAUrl = $customValue["popupCTAUrl"][0];
    $vaPopupImage = $customValue["popupImage"][0];
    ?>
    <div class="va-custom-post-input">
        <label>De afbeelding voor bovenaan de pagina:</label>
        <div class="va-custom-post-image">
            <div class="va-custom-post-image-row">
                <?php
                    if(!empty($vaPageHeaderImage) && $vaPageHeaderImage != ""){
                        ?>
                        <div class="va-custom-post-image-row-preview">
                            <div class="va-custom-post-image-row-preview-inner" style="background-image: url('<?php echo va_media_url($vaPageHeaderImage, "thumbnail"); ?>');"></div>
                        </div>
                        <label class="va-custom-post-image-row-name"><?php echo va_file_name($vaPageHeaderImage); ?></label>
                        <input name="pageHeaderImage" type="hidden" value="<?php echo $vaPageHeaderImage; ?>">
                        <?php
                    }else{
                        ?>
                        <div class="va-custom-post-image-row-preview">
                            <div class="va-custom-post-image-row-preview-inner"></div>
                        </div>
                        <label class="va-custom-post-image-row-name">Geen afbeelding gekozen</label>
                        <input name="pageHeaderImage" type="hidden" value="">
                        <?php
                    }
                ?>
                <div class="va-custom-post-image-row-controls">
                    <div class="va-custom-post-image-row-control-edit" onclick="add_image_uploader(this)">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path>
                            <path d="M0 0h24v24H0z" fill="none"></path>
                        </svg>
                    </div>
                    <div class="va-custom-post-image-row-control-delete" onclick="remove_image_uploader(this)">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
                            <path d="M0 0h24v24H0z" fill="none"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<div class="va-custom-post-input">
		<label>De titel voor bij de pagina afbeelding (indien leeg wordt de titel van de pagina overgenomen):</label>
        <input name="pageHeaderCustomTitle" value="<?php echo $vaPageHeaderCustomTitle; ?>" type="text" autocomplete="off">
    </div>
    <hr>
	<div class="va-custom-post-input">
		<label>De titel voor in de popup:</label>
        <input name="popupTitle" value="<?php echo $vaPopupTitle; ?>" type="text" autocomplete="off">
    </div>
	<div class="va-custom-post-input">
        <label>De tekst voor in de popup:</label>
        <textarea name="popupContent" rows="5"><?php echo $vaPopupContent ?></textarea>
    </div>
    <div class="va-custom-post-input">
        <label>De tekst voor de knop in de popup:</label>
        <input name="popupCTAText" value="<?php echo $vaPopupCTAText; ?>" type="text" autocomplete="off">
    </div>
    <div class="va-custom-post-input">
        <label>De link voor de knop in de popup:</label>
        <input name="popupCTAUrl" value="<?php echo $vaPopupCTAUrl; ?>" type="text" autocomplete="off">
    </div>
    <div class="va-custom-post-input">
        <label>De afbeelding voor in de popup:</label>
        <div class="va-custom-post-image">
            <div class="va-custom-post-image-row">
                <?php
                    if(!empty($vaPopupImage) && $vaPopupImage != ""){
                        ?>
                        <div class="va-custom-post-image-row-preview">
                            <div class="va-custom-post-image-row-preview-inner" style="background-image: url('<?php echo va_media_url($vaPopupImage, "thumbnail"); ?>');"></div>
                        </div>
                        <label class="va-custom-post-image-row-name"><?php echo va_file_name($vaPopupImage); ?></label>
                        <input name="popupImage" type="hidden" value="<?php echo $vaPopupImage; ?>">
                        <?php
                    }else{
                        ?>
                        <div class="va-custom-post-image-row-preview">
                            <div class="va-custom-post-image-row-preview-inner"></div>
                        </div>
                        <label class="va-custom-post-image-row-name">Geen afbeelding gekozen</label>
                        <input name="popupImage" type="hidden" value="">
                        <?php
                    }
                ?>
                <div class="va-custom-post-image-row-controls">
                    <div class="va-custom-post-image-row-control-edit" onclick="add_image_uploader(this)">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path>
                            <path d="M0 0h24v24H0z" fill="none"></path>
                        </svg>
                    </div>
                    <div class="va-custom-post-image-row-control-delete" onclick="remove_image_uploader(this)">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
                            <path d="M0 0h24v24H0z" fill="none"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
}

function va_page_header_image_save(){
    global $post;
    if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) {
        return $post_id;
    } else {
        update_post_meta($post->ID, "pageHeaderImage", $_POST["pageHeaderImage"]);
        update_post_meta($post->ID, "pageHeaderCustomTitle", $_POST["pageHeaderCustomTitle"]);
        update_post_meta($post->ID, "pageHeaderContent", $_POST["pageHeaderContent"]);
        update_post_meta($post->ID, "pageHeaderCTAText", $_POST["pageHeaderCTAText"]);
        update_post_meta($post->ID, "pageHeaderCTAUrl", $_POST["pageHeaderCTAUrl"]);
        update_post_meta($post->ID, "popupImage", $_POST["popupImage"]);
        update_post_meta($post->ID, "popupTitle", $_POST["popupTitle"]);
        update_post_meta($post->ID, "popupContent", $_POST["popupContent"]);
        update_post_meta($post->ID, "popupCTAText", $_POST["popupCTAText"]);
        update_post_meta($post->ID, "popupCTAUrl", $_POST["popupCTAUrl"]);
    }
}
?>