<?php
/*
	==========================================
	 Custom Field CTA banner
	==========================================
*/

function va_page_cta_banner_meta_box(){
    add_meta_box("page-cta-banner-meta-box", "Call to action banner naar deze pagina", "va_page_cta_banner_meta_box_html", "page", "normal", "low");
}

function va_page_cta_banner_meta_box_html(){
    global $post;
	// ophalen data
	if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) return $post_id;
    
    $customValue = get_post_custom($post->ID);

    $vaPageCTABannerImage = $customValue["pageCTABannerImage"][0];
    $vaPageCTABannerCustomTitle = $customValue["pageCTABannerCustomTitle"][0];
    $vaPageCTABannerContent = $customValue["pageCTABannerContent"][0];
    $vaPageCTABannerCTAText = $customValue["pageCTABannerCTAText"][0];
    ?>
    <div class="va-custom-post-input">
        <label>De afbeelding voor de call to action banner:</label>
        <div class="va-custom-post-image">
            <div class="va-custom-post-image-row">
                <?php
                    if(!empty($vaPageCTABannerImage) && $vaPageCTABannerImage != ""){
                        ?>
                        <div class="va-custom-post-image-row-preview">
                            <div class="va-custom-post-image-row-preview-inner" style="background-image: url('<?php echo va_media_url($vaPageCTABannerImage, "thumbnail"); ?>');"></div>
                        </div>
                        <label class="va-custom-post-image-row-name"><?php echo va_file_name($vaPageCTABannerImage); ?></label>
                        <input name="pageCTABannerImage" type="hidden" value="<?php echo $vaPageCTABannerImage; ?>">
                        <?php
                    }else{
                        ?>
                        <div class="va-custom-post-image-row-preview">
                            <div class="va-custom-post-image-row-preview-inner"></div>
                        </div>
                        <label class="va-custom-post-image-row-name">Geen afbeelding gekozen</label>
                        <input name="pageCTABannerImage" type="hidden" value="">
                        <?php
                    }
                ?>
                <div class="va-custom-post-image-row-controls">
                    <div class="va-custom-post-image-row-control-edit" onclick="add_image_uploader(this)">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path>
                            <path d="M0 0h24v24H0z" fill="none"></path>
                        </svg>
                    </div>
                    <div class="va-custom-post-image-row-control-delete" onclick="remove_image_uploader(this)">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
                            <path d="M0 0h24v24H0z" fill="none"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<div class="va-custom-post-input">
		<label>De titel voor de call to action banner (indien leeg wordt de titel van de pagina overgenomen):</label>
        <input name="pageCTABannerCustomTitle" value="<?php echo $vaPageCTABannerCustomTitle; ?>" type="text" autocomplete="off">
    </div>
	<div class="va-custom-post-input">
        <label>De tekst voor de call to action banner:</label>
        <textarea name="pageCTABannerContent" rows="5"><?php echo $vaPageCTABannerContent ?></textarea>
    </div>
    <div class="va-custom-post-input">
        <label>De tekst voor de knop in de call to action banner:</label>
        <input name="pageCTABannerCTAText" value="<?php echo $vaPageCTABannerCTAText; ?>" type="text" autocomplete="off">
    </div>
    <?php
}

function va_page_cta_banner_save(){
    global $post;
    if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) {
        return $post_id;
    } else {
        update_post_meta($post->ID, "pageCTABannerImage", $_POST["pageCTABannerImage"]);
        update_post_meta($post->ID, "pageCTABannerCustomTitle", $_POST["pageCTABannerCustomTitle"]);
        update_post_meta($post->ID, "pageCTABannerContent", $_POST["pageCTABannerContent"]);
        update_post_meta($post->ID, "pageCTABannerCTAText", $_POST["pageCTABannerCTAText"]);
    }
}
?>