<?php
/*
	==========================================
	 Custom post edit columns
	==========================================
*/

function va_custom_post_type_custom_columns($column){
    global $post;
    $customValue = get_post_custom();

    switch ($column) {
        case "postVolgorde":
            echo $customValue["postVolgorde"][0];

            break;
        case "pageHeaderImage":
            if(!empty($customValue["pageHeaderImage"][0]) && $customValue["pageHeaderImage"][0] != ""){
                ?>
                <img src="<?php echo va_media_url($customValue["pageHeaderImage"][0], "thumbnail"); ?>" />
            <?php
            }else{
                echo "Geen pagina afbeelding opgegeven";
            }
            
            break;
        case "pageHeaderImageSlider":
            if(!empty($customValue["pageHeaderImage"][0]) && $customValue["pageHeaderImage"][0] != ""){
                $pageHeaderImage_arr = json_decode($customValue["pageHeaderImage"][0]);
                $pageHeaderImage_length = count($pageHeaderImage_arr);
                $nrVisibleImages = 6;

                for ($i=0; $i < $nrVisibleImages; $i++) { 
                    $value = $pageHeaderImage_arr[$i];
                    ?>
                    <img src="<?php echo va_media_url($value, 'thumbnail'); ?>" alt="" />
                    <?php
                }
                if($pageHeaderImage_length > $nrVisibleImages){
                    if(($pageHeaderImage_length - $nrVisibleImages) == 1){
                        echo "<p>en nog 1 andere foto</p>";
                    } else {
                        echo "<p>en nog " . ($pageHeaderImage_length - $nrVisibleImages) . " andere foto's</p>";
                    }
                }
            }else{
                echo "Geen pagina afbeeldingen opgegeven";
            }
            
            break;
        case "pageHeaderCustomTitle":
            echo $customValue["pageHeaderCustomTitle"][0];

            break;
        case "pageHeaderContent":
            if(strlen($customValue["pageHeaderContent"][0]) > 240){
                echo substr($customValue["pageHeaderContent"][0], 0 , 240)."...";
            } else {
                echo $customValue["pageHeaderContent"][0];
            }

            break;
        case "serviceTeaserText":
            echo $customValue["serviceTeaserText"][0];

            break;
        case "serviceHome":
            if($customValue["serviceHome"][0] == "true"){
                echo "&check;";
            }

            break;
        case "serviceReadMore":
            if($customValue["serviceReadMore"][0] == "true"){
                echo "&check;";
            }

            break;
        case "referenceCategory":
            echo $customValue["referenceCategory"][0];

            break;
        case "referenceTeaser":
            if(!empty($customValue["referenceTeaser"][0]) && $customValue["referenceTeaser"][0] != ""){
                ?>
                    <img src="<?php echo va_media_url($customValue["referenceTeaser"][0], "thumbnail"); ?>" />
                <?php

                if(!empty($customValue["referenceImageList"][0]) && $customValue["referenceImageList"][0] != ""){
                    $referenceImageList_arr = json_decode($customValue["referenceImageList"][0]);
                    $referenceImageList_length = count($referenceImageList_arr);
                    $nrVisibleImages = 6;

                    for ($i=0; $i < $nrVisibleImages; $i++) { 
                        $value = $referenceImageList_arr[$i];
                        ?>
                        <img src="<?php echo va_media_url($value, 'thumbnail'); ?>" alt="" />
                        <?php
                    }
                    if($referenceImageList_length > $nrVisibleImages){
                        if(($referenceImageList_length - $nrVisibleImages) == 1){
                            echo "<p>en nog 1 andere foto</p>";
                        } else {
                            echo "<p>en nog " . ($referenceImageList_length - $nrVisibleImages) . " andere foto's</p>";
                        }
                    }
                }

            }else{
                echo "Geen afbeelding opgegeven";
            }
            
            break;
    }
} 

add_action("manage_posts_custom_column", "va_custom_post_type_custom_columns");
?>