<?php
/*
	==========================================
	 Clear page edit screen
	==========================================
*/

// remove auto p tag
// remove_filter("the_content", "wpautop");
// remove_filter("the_excerpt", "wpautop");

// Disable Fullscreen Mode Page Edit
if (is_admin()) { 
    function va_disable_editor_fullscreen_by_default() {
        $script = "jQuery(window).load(function() {const isFullscreenMode = wp.data.select('core/edit-post').isFeatureActive('fullscreenMode'); if (isFullscreenMode) {wp.data.dispatch('core/edit-post').toggleFeature('fullscreenMode');}});";
        wp_add_inline_script( "wp-blocks", $script );
    }
    add_action("enqueue_block_editor_assets", "va_disable_editor_fullscreen_by_default");
}

// disable manual font sizes
add_theme_support("disable-custom-font-sizes");

// adjust preset font sizes
add_theme_support("editor-font-sizes", array());

// disable custom colors
add_theme_support("disable-custom-colors");

// remove color palette
add_theme_support("editor-color-palette");

// allow block types 
function va_allowed_block_types($allowed_blocks, $post) {
 
	$allowed_blocks = array(
		"core/paragraph",
        "core/list",
        "core/heading",
        "core/image",
    );
 
	if($post->post_type == "page") {
        $pageTemplate = get_post_meta($post->ID, "_wp_page_template", true);

        if($pageTemplate == "page-temp-home.php"):
            $allowed_page_blocks = array(
                "lazyblock/p-home-intro",
                "lazyblock/p-slider",
            );
        else:
            $allowed_page_blocks = array();
        endif;
        
        $allowed_blocks = array_merge($allowed_blocks, $allowed_page_blocks);
    }

	return $allowed_blocks;
}

add_filter("allowed_block_types", "va_allowed_block_types", 10, 2);
?>