<?php
/*
	==========================================
	 Remove pages for not administrator
	==========================================
*/

if (!(current_user_can("administrator"))) {
	function remove_pages() {
	    remove_menu_page( "wpcf7" );
        remove_menu_page( "tools.php" );
        remove_menu_page( "edit-comments.php" );
        remove_menu_page( "edit.php" );
        remove_menu_page( "profile.php" );
        remove_submenu_page( "users.php", "profile.php" );
	}

    add_action("admin_menu", "remove_pages");
}

/*
	==========================================
	 show flamingo form backup list
	==========================================
*/

if (current_user_can("client")){
    add_filter("flamingo_map_meta_cap", function($meta_caps){
        $meta_caps = array_merge($meta_caps, array(
            "flamingo_edit_inbound_message" => "edit_pages",
            "flamingo_edit_inbound_messages" => "edit_pages",
        ));
      
        return $meta_caps;
    });
}

/*
	==========================================
	 Removes the Yoast Metabox for Roles other then Admins
	==========================================
*/

function check_user_role( $role, $user_id = null ) {
    if ( is_numeric( $user_id ) )
      $user = get_userdata( $user_id );
    else
      $user = wp_get_current_user();
    if ( empty( $user ) )
      return false;
    return in_array( $role, (array) $user->roles );
}

function wpse_init(){
    if( !( check_user_role( "administrator" )) ) {
      // Remove page analysis columns from post lists, also SEO status on post editor
      add_filter( "wpseo_use_page_analysis", "__return_false" );
      // Remove Yoast meta boxes
      add_action( "add_meta_boxes", "disable_seo_metabox", 100000 );
    }
}

add_action("init", "wpse_init");
  
function disable_seo_metabox() {
    remove_meta_box( "wpseo_meta", "post", "normal" );
    remove_meta_box( "wpseo_meta", "page", "normal" );
    // remove_meta_box( "wpseo_meta", "custompost", "normal" );
}

/*
	==========================================
	 Redirect users to front page after login
	==========================================
*/

function acme_login_redirect( $redirect_to, $request, $user  ) {
    return (is_array($user->roles) && (in_array("administrator", $user->roles))) ? admin_url() : site_url();
}

add_filter( "login_redirect", "acme_login_redirect", 10, 3 );
?>