<?php
/*
	==========================================
	 Convert post array to JSon string with article blocks
	==========================================
*/

function get_json_post_artikelblokken($postArray, $customPostType){
    $artikelPosition = null;
    $artikelBlokkenArray = array();

    foreach($postArray as $key => $value){
        $needle = "va" . $customPostType . "Artikelblokken_";
        if(strpos($key, $needle) !== false){
            $keySplit = explode("_", $key);
            $artikelPosition = $keySplit[1];
            $artikelKey = $keySplit[2];

            $escapers = array("\n", "\r", "\t");
            $replacements = array(" ", " ", "");
            $result = str_replace($escapers, $replacements, $value);
            if($artikelKey == "galerijItems"){
                if($keySplit[3] != null && $keySplit[3] != undefined){
                    $artikelBlokkenArray[$artikelPosition][$artikelKey][$keySplit[3]] = $result;
                }
            }
            else if($artikelKey == "lijstItems"){
                if($keySplit[3] != null && $keySplit[3] != undefined){
                    $artikelBlokkenArray[$artikelPosition][$artikelKey][$keySplit[3]][$keySplit[4]] = $result;
                }
            }else {
                $artikelBlokkenArray[$artikelPosition][$artikelKey] = $result;
            }
        }
    }
    return json_encode($artikelBlokkenArray, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
}
?>