<?php
/*
	==========================================
	 Activate Menus
	==========================================
*/

function va_theme_activate_menu(){
    add_theme_support("menus");
    add_theme_support("title-tag");
    register_nav_menu("header-primary", "Primary Header Navigation");
    register_nav_menu("footer-primary", "Primary Footer Navigation");
    register_nav_menu("footer-secondary", "Secondary Footer Navigation");
    register_nav_menu("footer-copy", "Footer Copy Navigation");
}

add_action("init", "va_theme_activate_menu");

/*
	==========================================
	 Hide Private & Draft Pages from the menu
	==========================================
*/

function va_filter_pages_from_menu ($items, $args) {
    foreach ($items as $ix => $obj) {
        if (!is_user_logged_in () && ("private" == get_post_status ($obj->object_id) || "draft" == get_post_status ($obj->object_id))) {
            unset ($items[$ix]);
        }
    }
    return $items;
}

add_filter ("wp_nav_menu_objects", "va_filter_pages_from_menu", 10, 2);
?>