<?php

class Mo_wpns_Scan_Handler_Cron{
	private $total_files_to_scan;
	public $scanned_files = array();
	function __construct(){

	}

	function mo2f_scan_all_files($scan_config, $start_time){
		ini_set('memory_limit', '-1');
		ini_set('max_execution_time', 0);
		$time_limit= ini_get('max_execution_time');

		$result = array();
		$folderpaths = array();
		$wp_repo_file = array();
		$folderNames = "";
		$repo_check_status_code=0;
		update_site_option('mo_stop_scan','0');
		$base = get_home_path();
		$hostname = 'wordpress.org';
		$uploads_dir = wp_upload_dir();
		$uploads_path= $uploads_dir['basedir'];
		if (!is_writable($uploads_path)) {
			$scan_config['check_repo'] = 0;
			$repo_check_status_code = -97;
		}else{
			$wordpress_server_status = $this->mo_wpns_check_malware_server_status($hostname);
			if (!$wordpress_server_status) {
				$scan_config['check_repo'] = 0;
				$repo_check_status_code = -98;
			}
		}
		
		if($scan_config['core_scan'] == 1){
			$folderpaths['base'] = $base;
			$folderNames .= "WP Files;";
		} 		
		if($scan_config['plugin_scan'] == 1){
			$folderpaths['plugins'] = WP_PLUGIN_DIR;
			$folderNames .= "Plugins;";
		}
		if($scan_config['theme_scan'] == 1){
			$folderpaths['themes'] = get_theme_root();
			$folderNames .= "Themes;";
		}
		if($scan_config['check_repo'] == 1){
			$folderNames .= "WP Repo Files;";
		}

		$this->count_total_files($folderpaths, $base, $scan_config);
		update_site_option('mo2f_repo_status', $repo_check_status_code);

		$mo2f_malware_db_handler = new MoWpnsDB();
		$reportid = $mo2f_malware_db_handler->create_scan_report($folderNames, $scan_config['type_scan'], $start_time, $repo_check_status_code);
		update_site_option('mo2f_report_id', $reportid);

		$scanverification=$this->createKeyCurrentScan($scan_config['type_scan'],$reportid);

		$response=$this->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, 1);

		wp_send_json('success');
	}

	function createKeyCurrentScan($scan_mode,$reportid){

		$scanverification=md5($scan_mode. MO2f_Utility::random_str(24).$reportid);
		update_site_option("mo2f_scanverification",$scanverification);
		return $scanverification;
	}

	function mo2f_wp_remote_get($scan_mode, $reportid, $scanverification,$scan_stage_complete=1){
		//set time out based on time left or 10 secs
        
        $scan_nonce=rand(10,100000);
		$http_header_array =array("Content-Type"=>"application/json","charset"=>"UTF-8","Authorization"=>"Basic");
		$url = get_site_url()."?scan_request=1"."&scanverification=".$scanverification."&reportid=".$reportid."&scan_stage_complete=".$scan_stage_complete."&scan_mode=".$scan_mode."&scan_nonce=".$scan_nonce;//scanverification,report_id, scan_stage_complete and scan_mode

		$args = array(
			'method' => 'GET',
			'body' => '',
			'timeout' => '5',
			'redirection' => '5',
			'httpversion' => '1.0',
			'blocking' => true,
			'headers' => $http_header_array
		);
		$response= wp_remote_get($url,$args);

	}

	function mo2f_download_core_wp($repo_file_path, $scan_config, $reportid, $scanverification){
		$repo_check_status = $scan_config['check_repo'];
		$repo_check_status_code=get_site_option('mo2f_repo_status');
		$wp_repo_file=get_site_option('mo2f_repo_path');
		if ( ! function_exists( 'get_plugins' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		if ( ! function_exists( 'plugins_api' ) ) {
		    require_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
		}
		
		if($scan_config['core_scan'] == 1 && $scan_config['check_repo'] && ($repo_check_status_code == 0)){
			if(!is_dir($repo_file_path)){
				mkdir($repo_file_path);
			}
			$download_status=time();
			$decoded_scan_configuration=json_decode(get_site_option('mo_wpns_scan_status'));
			$decoded_scan_configuration->status_download_time=$download_status;
			$encoded_scan_configuration=json_encode($decoded_scan_configuration);
			update_site_option("mo_wpns_scan_status",$encoded_scan_configuration);
            require(ABSPATH . 'wp-includes/version.php');
			//wordpress name to be changed to be changed based on version
			$zip_name="wp-".$wp_version;
			$wp_repo_file['base']=$repo_file_path.DIRECTORY_SEPARATOR.$zip_name;
			update_site_option('downloaded_wordpress_repo_name', $zip_name);

			$download_info = get_site_option('mo2f_download_info');
			if(! $download_info){
				$download_info = array("plugin_count"=>0, "theme_count"=>0, "stage"=> "core");
			}else{
				$download_info['stage'] = "core";
			}
			update_site_option('mo2f_download_info', $download_info);
			if(!is_dir($repo_file_path.DIRECTORY_SEPARATOR.$zip_name)){
				$result = $this->download_repo($zip_name, $wp_version, $repo_file_path);
				if($result === -99){
					$scan_config['check_repo'] = 0;
					$repo_check_status_code = -99;
				}else if($result === -95){
					$scan_config['check_repo'] = 0;
					$repo_check_status_code = -95;
				}else if(!$result){
					$scan_config['check_repo'] = 0;
					$repo_check_status_code = -100;
				}
			}

			if($repo_check_status != $scan_config['check_repo']){
				update_site_option('mo2f_repo_status', $repo_check_status_code);
				$scan_stage_complete=6;
			}else{
				update_site_option('mo2f_repo_path', $wp_repo_file);
				$scan_stage_complete=6;
			}
		}else{
			$scan_stage_complete = 7;
		}

		$Mo_wpns_Scan_Handler_Cron = new Mo_wpns_Scan_Handler_Cron();
		$response=$Mo_wpns_Scan_Handler_Cron->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, $scan_stage_complete);
		
	}

	function mo2f_download_plugins_wp($repo_file_path, $scan_config, $start_time, $time_limit, $reportid, $scanverification){
		$repo_check_status = $scan_config['check_repo'];
		$repo_check_status_code=get_site_option('mo2f_repo_status');
		$flag=0;
		$wp_repo_file=array();
		if ( ! function_exists( 'get_plugins' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		if ( ! function_exists( 'plugins_api' ) ) {
		    require_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
		}
		
		if($scan_config['plugin_scan'] == 1 && $scan_config['check_repo'] && ($repo_check_status_code == 0)){
			if(!is_dir($repo_file_path)){
				mkdir($repo_file_path);
			}
			$wp_plugin_repo_file=$repo_file_path.DIRECTORY_SEPARATOR."plugins";
			if(!is_dir($wp_plugin_repo_file)){
				mkdir($wp_plugin_repo_file);
			}
			$download_status=time();
			$decoded_scan_configuration=json_decode(get_site_option('mo_wpns_scan_status'));
			$decoded_scan_configuration->status_download_time=$download_status;
			$encoded_scan_configuration=json_encode($decoded_scan_configuration);
			update_site_option("mo_wpns_scan_status",$encoded_scan_configuration);
			$wp_repo_file['plugins']=$wp_plugin_repo_file;
			$plugin_list=get_site_transient( 'update_plugins' );

			$plugin_count = sizeof($plugin_list->checked);
			$download_info = array("plugin_count"=> $plugin_count, "theme_count"=>0, "stage"=>"plugins");
			update_site_option('mo2f_download_info', $download_info);

	        $all_plugins=array();
			foreach ($plugin_list as $key => $value) {
				if($key=='response'||$key=='no_update'){
					foreach ($value as $ke => $val) {
						$all_plugins[$ke] = $val;
					}
				}
			}
	        $result = $this->iterator_plugins_themes($all_plugins, $wp_plugin_repo_file, $start_time, $time_limit,$scan_config,$reportid, $scanverification, 'plugins');
	        if($result === -99){
				$scan_config['check_repo'] = 0;
				$repo_check_status_code = -99;
			}else if($result === -95){
				$scan_config['check_repo'] = 0;
				$repo_check_status_code = -95;
			}else if(!$result){
				$scan_config['check_repo'] = 0;
				$repo_check_status_code = -100;
			}else if($result === 'incomplete'){
				$flag=1;
			}
			
			if($repo_check_status != $scan_config['check_repo']){
				update_site_option('mo2f_repo_status', $repo_check_status_code);
				$scan_stage_complete=6;
			}else{
				if($flag == 1){
					$scan_stage_complete=3;
				}else{
					update_site_option('mo2f_repo_path', $wp_repo_file);
					$scan_stage_complete=6;
				}
			}
		}else{
			$scan_stage_complete = 4;
		}
		$Mo_wpns_Scan_Handler_Cron = new Mo_wpns_Scan_Handler_Cron();
		$response=$Mo_wpns_Scan_Handler_Cron->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, $scan_stage_complete);

	}

	function mo2f_download_themes_wp($repo_file_path, $scan_config, $start_time, $time_limit,$reportid, $scanverification){
		$repo_check_status = $scan_config['check_repo'];
		$repo_check_status_code=get_site_option('mo2f_repo_status');
		$flag=0;
		$wp_repo_file=get_site_option('mo2f_repo_path');
		if ( ! function_exists( 'get_plugins' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		if ( ! function_exists( 'plugins_api' ) ) {
		    require_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
		}
		
		if($scan_config['theme_scan'] == 1 && $scan_config['check_repo'] && ($repo_check_status_code == 0)){
			if(!is_dir($repo_file_path)){
				mkdir($repo_file_path);
			}
			$wp_theme_repo_file=$repo_file_path.DIRECTORY_SEPARATOR."themes";
			if(!is_dir($wp_theme_repo_file)){
				mkdir($wp_theme_repo_file);
			}
			$download_status=time();
			$decoded_scan_configuration=json_decode(get_site_option('mo_wpns_scan_status'));
			$decoded_scan_configuration->status_download_time=$download_status;
			$encoded_scan_configuration=json_encode($decoded_scan_configuration);
			update_site_option("mo_wpns_scan_status",$encoded_scan_configuration);
			$wp_repo_file['themes']=$wp_theme_repo_file;
			$all_themes=get_site_transient( 'update_themes' )->checked;

			$theme_count = sizeof($all_themes);
			$download_info = get_site_option('mo2f_download_info');
			if(! $download_info){
				$download_info = array("plugin_count"=>0, "theme_count"=> $theme_count, "stage"=> "themes");
			}else{
				$download_info['theme_count'] = $theme_count;
				$download_info['stage'] = "themes";
			}
			update_site_option('mo2f_download_info', $download_info);

	        $result = $this->iterator_plugins_themes($all_themes, $wp_theme_repo_file, $start_time, $time_limit,$scan_config,$reportid,$scanverification, 'themes');
	        if($result === -99){
				$scan_config['check_repo'] = 0;
				$repo_check_status_code = -99;
			}else if($result === -95){
				$scan_config['check_repo'] = 0;
				$repo_check_status_code = -95;
			}else if(!$result){
				$scan_config['check_repo'] = 0;
				$repo_check_status_code = -100;
			}else if($result === 'incomplete'){
				$flag=1;
			}
			
			if($repo_check_status != $scan_config['check_repo']){
				update_site_option('mo2f_repo_status', $repo_check_status_code);
				$scan_stage_complete=6;
			}else{
				if($flag == 1){
					$scan_stage_complete=4;

				}else{
					update_site_option('mo2f_repo_path', $wp_repo_file);
					$scan_stage_complete=6;
				}
			}
		}else{
			$scan_stage_complete = 5;
		}
		$Mo_wpns_Scan_Handler_Cron = new Mo_wpns_Scan_Handler_Cron();
		$response=$Mo_wpns_Scan_Handler_Cron->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, $scan_stage_complete);
	}

	function iterator_plugins_themes($themes_or_plugins, $path, $start_time, $time_limit, $scan_config,$reportid, $scanverification, $type=''){
		$downloaded_already= get_site_option('mo2f_download_done');
		if($downloaded_already == false){
			$downloaded_already=0;
		}
		$i=0;
        foreach($themes_or_plugins as $key => $data){
        	$i++;
        	$exec_status= $this->check_exec_limit($start_time, $time_limit);
        	if(! $exec_status){//wp_remote_get
        		update_site_option('mo2f_download_done', $i-1);
		        $Mo_wpns_Scan_Handler_Cron = new Mo_wpns_Scan_Handler_Cron();
		        if($type=='plugins'){
		        	$scan_stage_complete=3;
		        }else if($type=='themes'){
			        $scan_stage_complete=4;
		        }
		        $response=$Mo_wpns_Scan_Handler_Cron->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, $scan_stage_complete);
        		return 'incomplete';
        	}
        	if($i <= $downloaded_already){
        		continue;
        	}
        	if($type=='plugins'){
        		if(! file_exists(WP_PLUGIN_DIR.DIRECTORY_SEPARATOR.$data->plugin)){
        			continue;
        		}
	            $plugin_slug=$data->slug;
	            update_site_option('mo2f_current_repo_key', $plugin_slug);
	            $plugin_directory_location=dirname(dirname(dirname($path))).DIRECTORY_SEPARATOR.'plugins';
	            $plugin_data=get_plugin_data($plugin_directory_location.DIRECTORY_SEPARATOR.$data->plugin);
	            $plugin_version=$plugin_data['Version'];
	            if(!is_dir($path.DIRECTORY_SEPARATOR.$plugin_slug)){
	            	$result= $this->download_repo($plugin_slug, $plugin_version, $path, $type);
	            	if($result === -99){
						return -99;
					}else if($result === -95){
	            		return -95;
	            	}else if(!$result){
	            		return false;
	            	}else{
	            		update_site_option('mo2f_download_done', $i);
	            		return true;
	            	}
	            }
	        } else if($type=='themes'){
	        	$installed_themes = wp_get_themes();
	        	$flag_theme=0;
	        	foreach ($installed_themes as $theme_name => $attributes) {
	        		if($key == $theme_name){
	        			$flag_theme=1;
	        			break;
	        		}
	        	}
	        	if(!is_dir($path.DIRECTORY_SEPARATOR.$key) && $flag_theme == 1){
	        		update_site_option('mo2f_current_repo_key', $key);
	        		$result= $this->download_repo($key, $data, $path, $type);
	        		if($result === -99){
						return -99;
					}else if($result === -95){
	            		return -95;
	            	}else if(!$result){
	            		return false;
	            	}else{
	            		update_site_option('mo2f_download_done', $i);
	            		return true;
	            	}
	        	}
	        }
        }
        return true;
    }

    function download_repo($zip_name, $version, $path, $type=''){
		if ($type=='plugins') {
			$download_link="https://downloads.wordpress.org/plugin/".$zip_name.".".$version.".zip";
	        $plugin_name=$zip_name.'.'.$version;

	        $download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.".zip", wp_remote_retrieve_body(wp_remote_get($download_link)));
	        if( $download_result){
	            $result = $this->unzip_downloaded_repo($zip_name, $path);
	            return $result;
	        }else {
	        	$download_link="https://downloads.wordpress.org/plugin/".$zip_name.".zip";
	        	$download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.".zip", wp_remote_retrieve_body(wp_remote_get($download_link)));
	        	if( $download_result){
		            $result = $this->unzip_downloaded_repo($zip_name, $path);
		            return $result;
		        }else {
		        	$connectivity = $this->check_net_connectivity();
		        	if($connectivity){
		            	return -99;
		        	}else{
		        		return -95;
		        	}
		           
		        }
		        return -99;
	        }
		} else if($type=='themes'){
			$theme_name=$zip_name.'.'.$version;
			$download_link="https://downloads.wordpress.org/theme/".$theme_name.".zip";
	        $download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.".zip", wp_remote_retrieve_body(wp_remote_get($download_link)));
	        if( $download_result){
	            $result = $this->unzip_downloaded_repo($zip_name, $path);
	            return $result;
	        }else {
	        	$download_link="https://downloads.wordpress.org/theme/".$zip_name.".zip";
	        	$download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.".zip", wp_remote_retrieve_body(wp_remote_get($download_link)));
	        	if( $download_result){
		            $result = $this->unzip_downloaded_repo($zip_name, $path);
		            return $result;
		        }else {
		        	$connectivity = $this->check_net_connectivity();
		        	if($connectivity){
		        		error_log("Unable to download Theme: ".$theme_name);
		            	return -99;
		        	}else{
		        		return -95;
		        	}
		            
		        }
		        return -99;
	        }
		} else {
			update_site_option('mo2f_current_repo_key', 'core');
			$download_link="https://wordpress.org/wordpress-".$version.".zip";
			$download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.'.zip', wp_remote_retrieve_body(wp_remote_get($download_link)));
			if($download_result){
				$result=$this->unzip_downloaded_repo($zip_name, $path);
				return $result;
			} else {
				$connectivity = $this->check_net_connectivity();
				if($connectivity){
					error_log("Unable to download wordpress-".$version);
					return -99;
				}else{
	        		return -95;
	        	}
			}
		}
		return false;
	}

	function check_net_connectivity(){
		$hostname = 'wordpress.org';
		$flag=0;
		for ($i=0; $i <3 ; $i++) { 
			$net_connection = $this->mo_wpns_check_malware_server_status($hostname);
			if($net_connection){
				$flag=1;
				break;
			}else{
				sleep(5);
			}
		}
		if($flag){
			return true;
		}else{
			return false;
		}
	}

	function unzip_downloaded_repo($name, $path){
		$zip = new ZipArchive;
        $folder_path=$path.DIRECTORY_SEPARATOR.$name.".zip";
        $res = $zip->open($folder_path);
        if ($res === TRUE) {
            // extract it to the path we determined above
            $result = $zip->extractTo($path);
            $zip->close();
            if ($name == get_site_option('downloaded_wordpress_repo_name')) {
            	rename($path.DIRECTORY_SEPARATOR."wordpress", $path.DIRECTORY_SEPARATOR.$name);
            }
            unlink($folder_path);
            return true;
        } else {
            return false;
        }
	}

	function mo_wpns_check_malware_server_status($host){
		$fsock = @fsockopen($host, 80, $errno, $errstr, 5);
        if ( ! $fsock ){
            return FALSE;
        }else{
        	fclose($fsock);
            return TRUE;
        }
	}

	function mo_wpns_malware_scan_request( $host, $content_type,$postdata = array()){
		$response = null;
     
		$args = array(
            'method' => 'POST',
            'body' => $postdata,
            'timeout' => '5',
            'redirection' => '5',
            'sslverify'  =>true,
            'httpversion' => '1.0',
            'blocking' => true,
            'headers' => $content_type
        );
         
		$mo2f_api=new Mo2f_Api();
		$results=$mo2f_api->mo2f_wp_remote_post($host,$args);

		if($results==false){
			
		}else{
			$result = json_decode($results, true);
			if(isset($result['status'])){
				if ($result['status'] == 'success') {
					if($result['result']!='OK')
						$response = $result['result'];
				}else if($result['status']=='error'){
					error_log("Exception on server");
				}
			}else if(strpos($results, 'Summary')){
				
			}else{
				error_log("Any other issues on server");
			}
		}
		return $response;
	}

	function check_with_repo_files($file_content, $repo_file_path){
		$issues = array();
		if(file_exists($repo_file_path)){
	        $content=@file_get_contents($repo_file_path);
            $hash_repo = md5($content);
            $hash_file = md5($file_content);
            if ($hash_file != $hash_repo) {
            	$flag=1;
                $issues=array("exist" => "Mismatch in Files");
            }
	    } else {
	    	$issues=array('exist'=>'Unwanted File Found');
	    }
        return $issues;
	}

	function getlines($contents, $href){
		$newissues = 0;
		$lines = preg_split("/((\r?\n)|(\r\n?))/", $contents);
		for($i=0; $i<count($lines); $i++){
			$line =  $lines[$i];
			if (strpos($line, $href) !== false) {
				$newissues = $i+1;
			}
		}
		return $newissues;
	}

	function check_external_link($contents){
		$issues = array();
		$hrefs = preg_match_all('/<a\s+(?:[^"\'>]+|"[^"]*"|\'[^\']*\')*href=("[^"]+"|\'[^\'‌​]+\'|[^<>\s]+)/i', $contents, $matches) ? $matches: array();
		if(isset($hrefs[1])){
			foreach($hrefs[1] as $href){
				if($this->isexternal($href)){
					$line=$this->getlines($contents, $href);
					$issues[] = array("i"=>"eld", "d"=>$href, "l"=>$line);
				}
			}
		}
		return $issues;
	}

	function isexternal($url) {
	  $url = trim($url);
	  $url = trim($url,';');
	  $url = trim($url,'(');
	  $url = trim($url,')');
	  $url = trim($url,"'");
	  $url = trim($url,'"');
	  $components = parse_url($url); 
	  if(isset($components['host'])){
	  	if(preg_match('/(wordpress|google|miniorange|xecurify|facebook|themeisle|adobe|phppot|php.net)/i', $components['host']) === 1) {}
	  	else{
			if(!empty($components['host']) && strpos(strtolower($components['host']),strtolower($_SERVER['HTTP_HOST'])) === false){
				return true;
			}
		}
	  }
	  return false;
	}	

	function getFunctionArgumentsOrEnclosedString($issueFunction, $tokens, $start, $issuetype, $checkForExternalLink){
		
		$flag = 1;
		$argument = "";
		$line = "";
		$issue = array();
		for($j=$start; $j< sizeof($tokens); $j++) {
			$innertoken = $tokens[$j];
			if ($flag==1 && is_array($innertoken)) {
				$argument .= $innertoken[1];
				if(empty($line))
					$line = $innertoken[2];
			} else if($innertoken==";"){
				$argument .= ";";
				if($checkForExternalLink){
					if($this->isexternal($argument)){
						$issue = array("l"=>$line, "t"=> $issueFunction, "i"=>$issuetype, "d"=>$argument);
					}
				} else {
					$issue = array("l"=>$line, "t"=> $issueFunction, "i"=>$issuetype, "d"=>$argument);
				}
				break;
			} else if($flag==1){
				$argument .= $innertoken;
			}
		}
		return $issue;
	}

	function remove_dir($repo_path){
		$dir=$repo_path;
		$it = new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS);
		$files = new RecursiveIteratorIterator($it,RecursiveIteratorIterator::CHILD_FIRST);
		foreach($files as $file) {
		    if ($file->isDir()){
		        rmdir($file->getPathname());
		    } else {
		        unlink($file->getPathname());
		    }
		}
		rmdir($dir);
	}

	function count_total_files($folder_paths, $base, $scan_config){
		
		$plugin_list=get_site_transient( 'update_plugins' );
		$q = $plugin_list->checked;
		$plugin_array = array();
		foreach ($q as $key => $value) {
			if(strpos($key, '/')){
				$a=explode('/', $key);
				array_push($plugin_array, $a[0]);
			}else{
				array_push($plugin_array, $key);
			}
		}
		$all_themes=get_site_transient( 'update_themes' )->checked;
		$theme_array = array();
		foreach ($all_themes as $key => $value) {
			array_push($theme_array, $key);
		}
		$mo2f_malware_db_handler = new MoWpnsDB();
		$file_count=0;
		$nooffiles=0;
		$file_path_array=array();
		$skip_path_array= array();
		$folder_skip_array=array();
		$extensions = array();
		$files_number = 0;
		if($scan_config['type_scan'] == "Custom Scan"){
			$file_ext = $scan_config['file_extension'];
			if(empty($file_ext)){

			}else{
				if(strpos($file_ext,';') !=false){
					$extensions = explode(";", $file_ext);
				}else{
					array_push($extensions, $file_ext);
				}
			}
			$folder_skip_array= empty($scan_config['path_skip']) ? array() : explode(";", $scan_config['path_skip']);

			for($i=0; $i<count($folder_skip_array); $i++){
				$pathParts = explode('/', $folder_skip_array[$i]);
				$n= sizeof($pathParts)-1;
				$folder= $pathParts[$n];
				array_push($skip_path_array, $folder);
			}
		}
		foreach ($folder_paths as $key_path => $value) {
			$file_list= list_files($value,100);
			if(isset($folder_paths['base'])){
				if($key_path == 'base'){
					$files_number = sizeof($file_list);
				}
			}else{
				$files_number+= sizeof($file_list);
			}
			foreach ($file_list as $key => $value1) {

				$source_file_path= $value1;

				if(is_dir($source_file_path)){
					continue;
				}
				$source_file_path_for_explode = str_replace('/', '\\', $source_file_path);
				$arr= explode('\\', $source_file_path_for_explode);
				$theme_path=get_theme_root();
				if ($value == $base && ($scan_config['core_scan'] == 1)){
					if(($arr[count($arr)-1]== 'index.php' && (count($arr)==1 || in_array($arr[count($arr)-2], array('wp-content', 'plugins', 'themes'))) && !in_array('miniorangescan', $arr)) || (!in_array('plugins', $arr) && !in_array('themes', $arr) && !in_array('miniorangescan', $arr))){
								
					}else{
						continue;
					}
				}elseif ($value == WP_PLUGIN_DIR && $arr[count($arr)-1]=='index.php'){
					continue;
				}elseif ($value == $theme_path &&  $arr[count($arr)-1]=='index.php'){
					continue;
				}
				$ext = pathinfo($source_file_path, PATHINFO_EXTENSION);
				if($scan_config['type_scan'] == "Custom Scan"){
					$flag_skip=0;
					if (!empty($folder_skip_array)) {
						for($q=0; $q<count($skip_path_array); $q++){
							if(strpos($source_file_path, $skip_path_array[$q])){
								$flag_skip=1;
								break;
							}
						}
					}
					if($flag_skip == 1){
						continue;
					}
					
					if(!empty($extensions)){
						if(!in_array($ext, $extensions)){
							continue;
						}
					}
				}
				if(in_array($ext, array('zip', 'log', 'htaccess','sitx','7z','rar','gz','tar.gz','jpg','jpeg','png','gif','svg','tiff','raw'))){
					continue;
				}
				$file_count++;
				$nooffiles=$nooffiles+1;

				if(in_array('wp-content', $arr) && in_array('plugins', $arr)){//plugins file
					foreach ($plugin_array as $arr_index => $key_repo) {
						if(in_array($key_repo, $arr)){
							$repo_key = $key_repo;
							break;
						}
					}
				}
				else if(in_array('wp-content', $arr) && in_array('themes', $arr)){//themes file
					foreach ($theme_array as $arr_index => $key_repo) {
						if(in_array($key_repo, $arr)){
							$repo_key = $key_repo;
							break;
						}
					}
				}
				else{//core file
					$repo_key = 'core';
				}

				$file_path_array[$nooffiles]= array("file"=> $source_file_path, "key"=>$repo_key);
				if($nooffiles>0 && $nooffiles%100==0){
					$mo2f_malware_db_handler->insert_files_in_parts($file_path_array);
					$nooffiles=0;
					$file_path_array=array();
				}
			}
			$mo2f_malware_db_handler->insert_files_in_parts($file_path_array);
			$nooffiles=0;
			$file_path_array=array();
			$decoded_scan_status=json_decode(get_site_option('mo_wpns_scan_status'));
			$decoded_scan_status->total_files=$file_count;
			$encoded_scan_status=json_encode($decoded_scan_status);
			update_site_option("mo_wpns_scan_status",$encoded_scan_status);
			$mo2f_files_skipped = $files_number-$file_count;
			update_site_option('mo2f_files_skipped', $mo2f_files_skipped);
		}
	}

	function    averageFileScanTime($currentFileScanTime,$currentScanFileCount,$averageFileScanTime,$previous_scanned){

		if($previous_scanned!=0 || $currentScanFileCount!=0) {
			try {
				$totalTime           = (float)($averageFileScanTime * $previous_scanned);
				$timeDifference      = time() - $currentFileScanTime;
				$avergaeTimeEachFile = (float)(( $totalTime + $timeDifference )) / (float)(( $previous_scanned + $currentScanFileCount ));

			} catch ( Exception $e ) {
				$avergaeTimeEachFile = 0;
			}
		}else{
			$avergaeTimeEachFile = 0;
		}
		return $avergaeTimeEachFile;
	}

	function get_scan_result_parts( $scan_config, $start_time, $time_limit,$mo2f_malware_db_handler=null, $folderpaths=array()){
		if(!empty($folderpaths)){
			if ( in_array( 'curl', get_loaded_extensions() ) ) {
				$scanresults=array();
				$nooffiles=0;
				$decoded_scan_status=json_decode(get_site_option('mo_wpns_scan_status'));
				$previous_scanned = $decoded_scan_status->files_scanned;
				$previous_processed_files=$decoded_scan_status->total_files_processed;
				$scan_malware_count = 0;
				$repo_issue_count = 0;
				$malicious_link_count = 0;
				$file_ext = $scan_config['file_extension'];
				$host = MoWpnsConstants::$host;
				$extensions = array();
				$hostname = MoWpnsConstants::$hostname;
				$malware_server_status = $this->mo_wpns_check_malware_server_status($hostname);
				if(empty($file_ext)){
				}else{
					if(strpos($file_ext,';') !=false){
						$extensions = explode(";", $file_ext);
					}else{
						array_push($extensions, $file_ext);
					}
				}
				$folder_skip_array= empty($scan_config['path_skip']) ? array() : explode(";", $scan_config['path_skip']);
				$skip_path_array= array();
				for($i=0; $i<count($folder_skip_array); $i++){
					$pathParts = explode('/', rtrim(str_replace('\\', '/', $folder_skip_array[$i])));
					$n= sizeof($pathParts)-1;
					$folder= $pathParts[$n];
					array_push($skip_path_array, $folder);
				}
				$enable_extns = $scan_config['type_scan'] == "Custom Scan" && !empty($file_ext) ? false : true;
				$currentFileScanTime=time();
				$currentScanFileCount=$nooffiles;
				$avergaeTimeEachFile=0;//in miliseconds
				foreach ($folderpaths as $value) {
					$status=$this->check_exec_limit($start_time, $time_limit);//check limit for each file.

					if(!$status){//wp_remote_get
						$decoded_scan_status->average_time_each_file=$this->averageFileScanTime($currentFileScanTime,$nooffiles,$decoded_scan_status->average_time_each_file,$previous_processed_files);
						$decoded_scan_status->total_files_processed=$decoded_scan_status->total_files_processed+$nooffiles;
						$mo_wpns_files_scanned=(0.7*$nooffiles)+$previous_scanned;
						$decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
						$encoded_scan_status=json_encode($decoded_scan_status);
						update_site_option('mo_wpns_scan_status', $encoded_scan_status);
						return array('file_count'=> $nooffiles, 'malware_count'=>$scan_malware_count, 'repo_issues'=>$repo_issue_count, 'malicious_link'=>$malicious_link_count, 'scan'=>$scanresults);
						//time limit close by. Returned status of current scan. Update DB and make next request.
					}

					$scanresult=array();
					$source_file_path=$value->path;
					if(!file_exists($source_file_path)){
						$nooffiles++;
						continue;
					}
					
					$source_file_path_size = str_replace("\\", "/", $source_file_path);
					
					$ext = pathinfo($source_file_path, PATHINFO_EXTENSION);
					$ext= strtolower($ext);
					if(!((filesize($source_file_path_size) < 1048576)) ){
						$excess_size = get_site_option('mo2f_file_size_excess');
						update_site_option('mo2f_file_size_excess', $excess_size+1);
					   	$nooffiles++;
						continue;
					}
					$extns = $enable_extns ? true : (in_array($ext, $extensions) ? true : false);
					if($extns){
						$nooffiles++;
						if((0.7*$nooffiles) > 50){
							$mo_wpns_files_scanned=((0.7*$nooffiles)+$previous_scanned);
							$decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
							$encoded_scan_status=json_encode($decoded_scan_status);
							update_site_option('mo_wpns_scan_status', $encoded_scan_status);

						}
					}

                    $hash_of_file= md5_file($source_file_path);
                    $res=$mo2f_malware_db_handler->check_hash($hash_of_file);
                    $datascan = empty($res)?true:(isset($res[0]->scan_data) ? unserialize($res[0]->scan_data):false);
                    $scanmalware = is_array($datascan)?$datascan['malware']==0:(!empty($datascan) ? $datascan: true);
                    $malware_status = $scanmalware? 0 : 1;

                    if(!empty($res) && !$scanmalware ){
                    }                	 
                    else{
                    	$flag_update=0;
						if((filesize($source_file_path_size) < 1048576) ){
							$file_content=file_get_contents($source_file_path);
						
							if(($scan_config['check_vulnerable'] == 1 || $scan_config['check_sql'] == 1) && !in_array($ext, array('zip','sitx','7z','rar','gz','tar.gz','jpg','jpeg','png','gif','svg','tiff','raw')) && filesize($source_file_path_size) < 1048576 && $malware_server_status && $extns && $scanmalware){
								$malware_status = 1;
								$cfile=curl_file_create($source_file_path, 'test/plain', time().basename($source_file_path));
								$postdata = array('file' => $cfile);
																	
								$content_type = 'multipart/form-data';
								$issues = $this->mo_wpns_malware_scan_request($host, $content_type,$postdata);
								if ($issues) {
									$scan_malware_count++;
									$scanresult['scan'] = $issues;
									$flag_update=1;
								}
							}else{

							}
						}

							if($flag_update == 0){
								$malware_status = ($scan_config['check_vulnerable'] || $scan_config['check_sql']) && $malware_status ? 1 : 0;
								$repo_status=0;
								$link_status=0;
								$scan_data = array('malware'=>$malware_status, 'repo'=>$repo_status, 'ext_link'=>$link_status);
								if(empty($res)){
									$mo2f_malware_db_handler->insert_hash($source_file_path, $hash_of_file, $scan_data);
								}else{
									$mo2f_malware_db_handler->update_hash($source_file_path, $hash_of_file, $scan_data);
								}
							}else{
								$infected_files=get_site_option('mo_wpns_infected_files');
								$infected_files++;
								update_site_option('mo_wpns_infected_files', $infected_files);
							}
						}
						if(!empty($scanresult))
							$scanresults[$source_file_path]=$scanresult;

				}
				$decoded_scan_status->average_time_each_file=$this->averageFileScanTime($currentFileScanTime,$nooffiles,$decoded_scan_status->average_time_each_file,$previous_processed_files);
				$decoded_scan_status->total_files_processed=$decoded_scan_status->total_files_processed+$nooffiles;
				$mo_wpns_files_scanned=((0.7*$nooffiles)+$previous_scanned);
				$decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
				$encoded_scan_status=json_encode($decoded_scan_status);
				update_site_option('mo_wpns_scan_status', $encoded_scan_status);

				return array('file_count'=> $nooffiles, 'malware_count'=>$scan_malware_count, 'repo_issues'=>$repo_issue_count, 'malicious_link'=>$malicious_link_count, 'scan'=>$scanresults);
			}else{
				return array('message'=>'CURL not installed on the server.');
			}
		} else {
			return array('message'=>'No folder selected for scanning.');
		}
	}

	function scan_for_ext_link($files_to_scan, $scan_config, $start_time, $time_limit, $reportid){
		$mo2f_malware_db_handler = new MoWpnsDB();
		$scanresults=array();
		$decoded_scan_status=json_decode(get_site_option('mo_wpns_scan_status'));
		$previous_scanned = $decoded_scan_status->files_scanned;
		$currentFileScanTime=time();
		$nooffiles=0;
		$malicious_link_count=0;
		$previous_processed_files=$decoded_scan_status->total_files_processed;
		foreach ($files_to_scan as $value) {
			$status=$this->check_exec_limit($start_time, $time_limit);//check limit for each file.
			if(!$status){//wp_remote_get
				$decoded_scan_status->average_time_each_file=$this->averageFileScanTime($currentFileScanTime,$nooffiles,$decoded_scan_status->average_time_each_file,$previous_processed_files);
				$decoded_scan_status->total_files_processed=$decoded_scan_status->total_files_processed+$nooffiles;
				$mo_wpns_files_scanned=(0.15*$nooffiles)+$previous_scanned;
				$decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
				$encoded_scan_status=json_encode($decoded_scan_status);
				update_site_option('mo_wpns_scan_status', $encoded_scan_status);
				return array('file_count'=> $nooffiles, 'malicious_link'=>$malicious_link_count, 'scan'=>$scanresults); 
			}
			$flag_update=0;
			$nooffiles++;
			if((0.15*$nooffiles)> 50){// remove get_site_option
				$decoded_scan_status->average_time_each_file=$this->averageFileScanTime($currentFileScanTime,$nooffiles,$decoded_scan_status->average_time_each_file,$previous_processed_files);
				$decoded_scan_status->total_files_processed=$decoded_scan_status->total_files_processed+$nooffiles;
				$mo_wpns_files_scanned=(0.15*$nooffiles)+$previous_scanned;
				$decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
				$encoded_scan_status=json_encode($decoded_scan_status);
				update_site_option('mo_wpns_scan_status', $encoded_scan_status);
			}
			$source_file_path=$value->path;
			if(!file_exists($source_file_path)){
				continue;
			}
			if(filesize($source_file_path) > 5242880){//5MB size limit
				$excess_size = get_site_option('mo2f_file_size_excess');
				update_site_option('mo2f_file_size_excess', $excess_size+1);
			}

			$hash_of_file= md5_file($source_file_path);
		    $res=$mo2f_malware_db_handler->check_hash($hash_of_file);
		    $datascan = empty($res)?true:(isset($res[0]->scan_data) ? unserialize($res[0]->scan_data):false);
		    $extlink = is_array($datascan)?$datascan['ext_link']==0:(!empty($datascan) ? $datascan: true);
			$link_status = $extlink? 0 : 1;
			if(is_array($datascan)){
				$malware_status= $datascan['malware'];
			}else{
				$malware_status=0;
			}

			$scanresult=array();
			
			$file_content=file_get_contents($source_file_path);
			if($scan_config['ext_link_check'] == 1 && $extlink){
				$link_status=1;
				$elresult= $this->check_external_link($file_content);
				if(!empty($elresult)){
					$malicious_link_count++;
					$flag_update=1;
					$scanresult['extl']=$elresult;
				}
			}

			if($flag_update == 0){
				$link_status = $scan_config['ext_link_check'] && $link_status ? 1: 0;
				$repo_status=0;

				$scan_data = array('malware'=>$malware_status, 'repo'=>$repo_status, 'ext_link'=>$link_status);
				$infected_array=$mo2f_malware_db_handler->get_detail_report_with_id($reportid);
				$file_already_infected=false;
				foreach ($infected_array as $key => $value) {
					if($value->filename == $source_file_path){
						$file_already_infected=true;
						break;
					}
				}

				if($file_already_infected){

				}elseif(empty($res)){
					$mo2f_malware_db_handler->insert_hash($source_file_path, $hash_of_file, $scan_data);
				}else{
					$mo2f_malware_db_handler->update_hash($source_file_path, $hash_of_file, $scan_data);
				}
			}else{
				$infected_files=get_site_option('mo_wpns_warning_files');
				$infected_files++;
				update_site_option('mo_wpns_warning_files', $infected_files);
			}
			if(!empty($scanresult))
				$scanresults[$source_file_path]=$scanresult;
		}
		$decoded_scan_status->average_time_each_file=$this->averageFileScanTime($currentFileScanTime,$nooffiles,$decoded_scan_status->average_time_each_file,$previous_processed_files);
		$decoded_scan_status->total_files_processed=$decoded_scan_status->total_files_processed+$nooffiles;
		$mo_wpns_files_scanned=(0.15*$nooffiles)+$previous_scanned;
		$decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
		$encoded_scan_status=json_encode($decoded_scan_status);
		update_site_option('mo_wpns_scan_status', $encoded_scan_status);
		return array('file_count'=> $nooffiles, 'malicious_link'=>$malicious_link_count, 'scan'=>$scanresults);
	}

	function scan_with_repo($files_to_scan, $scan_config, $start_time, $time_limit, $reportid, $repo_file_path){
		$mo2f_malware_db_handler = new MoWpnsDB();
		$scanresults=array();
		$default_themes = array('twentynineteen', 'twentyseventeen', 'twentysixteen', 'twentytwenty');
		$decoded_scan_status=json_decode(get_site_option('mo_wpns_scan_status'));
		$previous_scanned = $decoded_scan_status->files_scanned;
		$previous_processed_files=$decoded_scan_status->total_files_processed;
		$nooffiles=0;
		$repo_issue_count=0;
		$currentFileScanTime=time();
		foreach ($files_to_scan as $value) {
			$status=$this->check_exec_limit($start_time, $time_limit);//check limit for each file.
			if(!$status){//wp_remote_get
				$decoded_scan_status->average_time_each_file=$this->averageFileScanTime($currentFileScanTime,$nooffiles,$decoded_scan_status->average_time_each_file,$previous_processed_files);
				$decoded_scan_status->total_files_processed=$decoded_scan_status->total_files_processed+$nooffiles;
				$mo_wpns_files_scanned=(0.15*$nooffiles)+$previous_scanned;
				$decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
				$encoded_scan_status=json_encode($decoded_scan_status);
				update_site_option('mo_wpns_scan_status', $encoded_scan_status);
				return array('file_count'=> $nooffiles, 'repo_issues'=>$repo_issue_count, 'scan'=>$scanresults);
				//time limit close by. Returned status of current scan. Update DB and make next request.
			}
			$flag_update=0;
			$nooffiles++;
			if((0.15*$nooffiles) > 50){
				$decoded_scan_status->average_time_each_file=$this->averageFileScanTime($currentFileScanTime,$nooffiles,$decoded_scan_status->average_time_each_file,$previous_processed_files);
				$decoded_scan_status->total_files_processed=$decoded_scan_status->total_files_processed+$nooffiles;
				$mo_wpns_files_scanned=(0.15*$nooffiles)+$previous_scanned;
				$decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
				$encoded_scan_status=json_encode($decoded_scan_status);
				update_site_option('mo_wpns_scan_status', $encoded_scan_status);
			}
			$source_file_path=$value->path;
			if(!file_exists($source_file_path)){
				continue;
			}
			if(filesize($source_file_path) > 5242880){//5MB size limit
				$excess_size = get_site_option('mo2f_file_size_excess');
				update_site_option('mo2f_file_size_excess', $excess_size+1);
			}
			$hash_of_file= md5_file($source_file_path);
		    $res=$mo2f_malware_db_handler->check_hash($hash_of_file);
		    $datascan = empty($res)?true:(isset($res[0]->scan_data) ? unserialize($res[0]->scan_data):false);
		    $repocheck = is_array($datascan)?$datascan['repo']==0:(!empty($datascan) ? $datascan: true);
		    $repo_status = $repocheck? 0 : 1;
		    if(is_array($datascan)){
		    	$malware_status = $datascan['malware'];
		    	$link_status = $datascan['ext_link'];
		    }else{
		    	$malware_status=0;
		    	$link_status=0;
		    }
			$scanresult=array();

			if($repocheck){
				$file_content=file_get_contents($source_file_path);
				$file_path_slash_correction = str_replace('/', '\\', $source_file_path);
				$source_file_path_array=explode("\\", $file_path_slash_correction);
				$theme_flag=0;
				foreach ($default_themes as $theme_key) {
					if(in_array($theme_key, $source_file_path_array)){
						$theme_flag=1;
						break;
					}
				}
				if($theme_flag){
					continue;
				}
				if(in_array('wp-content', $source_file_path_array) && !in_array('plugins', $source_file_path_array) && !in_array('themes', $source_file_path_array)){
					continue;
				}
				$repo_file_to_check=$repo_file_path;
				$path_flag=0;
				$path_key= array('wp-admin', 'wp-includes', 'plugins', 'themes');
				foreach ($path_key as $paths_key) {
					if(in_array($paths_key, $source_file_path_array)){
						$index= array_search($paths_key, $source_file_path_array);
						if($paths_key == 'wp-admin' || $paths_key == 'wp-includes'){
							$wordpress_name = get_site_option('downloaded_wordpress_repo_name');
							$repo_file_to_check.=DIRECTORY_SEPARATOR.$wordpress_name;
						}
						for($i=$index; $i<sizeof($source_file_path_array); $i++){
							$repo_file_to_check.=DIRECTORY_SEPARATOR.$source_file_path_array[$i];
						}
						$path_flag=1;

						break;
					}
				}
				if($path_flag == 0){
					$last_index=sizeof($source_file_path_array)-1;
					$wordpress_name = get_site_option('downloaded_wordpress_repo_name');
					$repo_file_to_check.=DIRECTORY_SEPARATOR.$wordpress_name.DIRECTORY_SEPARATOR.$source_file_path_array[$last_index];
				}
				$repo_status=1;
				$issues = $this->check_with_repo_files($file_content, $repo_file_to_check);
	           	if(!empty($issues)){
	           		$repo_issue_count++;
	           		$scanresult['repo']=$issues;
	           		$flag_update=1;
	            }
	        }

            if($flag_update == 0){
				$repo_status = $scan_config['check_repo'] && $repo_status ? 1 : 0;

				$scan_data = array('malware'=>$malware_status, 'repo'=>$repo_status, 'ext_link'=>$link_status);
				$infected_array=$mo2f_malware_db_handler->get_detail_report_with_id($reportid);
				$file_already_infected=false;
				foreach ($infected_array as $key => $value) {
					if($value->filename == $source_file_path){
						$file_already_infected=true;
						break;
					}
				}

				if($file_already_infected){

				}elseif(empty($res)){
					$mo2f_malware_db_handler->insert_hash($source_file_path, $hash_of_file, $scan_data);
				}else{
					$mo2f_malware_db_handler->update_hash($source_file_path, $hash_of_file, $scan_data);
				}
			}else{
				$infected_files=get_site_option('mo_wpns_warning_files');
				$infected_files++;
				if(!empty($res)){
					$mo2f_malware_db_handler->delete_hash($source_file_path);
				}
				update_site_option('mo_wpns_warning_files', $infected_files);
			}
			if(!empty($scanresult))
				$scanresults[$source_file_path]=$scanresult;
		}
		$decoded_scan_status->average_time_each_file=$this->averageFileScanTime($currentFileScanTime,$nooffiles,$decoded_scan_status->average_time_each_file,$previous_processed_files);
		$decoded_scan_status->total_files_processed=$decoded_scan_status->total_files_processed+$nooffiles;
		$mo_wpns_files_scanned=(0.15*$nooffiles)+$previous_scanned;
		$decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
		$encoded_scan_status=json_encode($decoded_scan_status);
		update_site_option('mo_wpns_scan_status', $encoded_scan_status);
		return array('file_count'=> $nooffiles, 'repo_issues'=>$repo_issue_count, 'scan'=>$scanresults);
	}

	function check_exec_limit($start_time, $time_limit){
		if($time_limit == 0){
			return true;
		}else{
			$time_remaining= $time_limit - (time()-$start_time);
			if($time_remaining > 10){
				return true;
			}else{
				return false;
			}
		}
	}

}
new Mo_wpns_Scan_Handler_Cron;
?>